#ifndef __ECMV4_ERROR_H
#define __ECMV4_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 AP Task Error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECMV4_AP_FIRMWARE_HAS_CRASHED
//
// MessageText:
//
//  Firmware has crashed.
//
#define TLR_E_ECMV4_AP_FIRMWARE_HAS_CRASHED ((TLR_RESULT)0xC0D70001L)

//
// MessageId: TLR_E_ECMV4_AP_CONFIGURATION_INTERFACE_NOT_AVAILABLE
//
// MessageText:
//
//  Configuration interface not currently available.
//
#define TLR_E_ECMV4_AP_CONFIGURATION_INTERFACE_NOT_AVAILABLE ((TLR_RESULT)0xC0D70002L)

//
// MessageId: TLR_E_ECMV4_AP_SET_TARGET_STATE_NOT_ALLOWED_DURING_CFG_LOADING
//
// MessageText:
//
//  Set Target State is not allowed during configuration loading.
//
#define TLR_E_ECMV4_AP_SET_TARGET_STATE_NOT_ALLOWED_DURING_CFG_LOADING ((TLR_RESULT)0xC0D70003L)

//
// MessageId: TLR_E_ECMV4_AP_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid startup parameter.
//
#define TLR_E_ECMV4_AP_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0D70004L)

/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 LLD Error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECMV4_LLD_TIMEOUT
//
// MessageText:
//
//  ESC Register access timeout.
//
#define TLR_E_ECMV4_LLD_TIMEOUT          ((TLR_RESULT)0xC0CC0001L)

//
// MessageId: TLR_E_ECMV4_LLD_UNSUPPORTED_COMMAND
//
// MessageText:
//
//  LLD: Unsupported EtherCAT telegram command.
//
#define TLR_E_ECMV4_LLD_UNSUPPORTED_COMMAND ((TLR_RESULT)0xC0CC0003L)

//
// MessageId: TLR_E_ECMV4_LLD_DUPLICATE_FIXED_STATION_ADDRESS
//
// MessageText:
//
//  LLD: Duplicate fixed station address.
//
#define TLR_E_ECMV4_LLD_DUPLICATE_FIXED_STATION_ADDRESS ((TLR_RESULT)0xC0CC0004L)

//
// MessageId: TLR_E_ECMV4_LLD_SII_CHECKSUM_ERROR
//
// MessageText:
//
//  LLD: SII Checksum Error.
//
#define TLR_E_ECMV4_LLD_SII_CHECKSUM_ERROR ((TLR_RESULT)0xC0CC0005L)

//
// MessageId: TLR_E_ECMV4_LLD_SII_EEPROM_LOADING_ERROR
//
// MessageText:
//
//  LLD: SII EEPROM Loading Error.
//
#define TLR_E_ECMV4_LLD_SII_EEPROM_LOADING_ERROR ((TLR_RESULT)0xC0CC0006L)

//
// MessageId: TLR_E_ECMV4_LLD_SII_MISSING_ERROR_ACK
//
// MessageText:
//
//  LLD: SII Missing Error Ack.
//
#define TLR_E_ECMV4_LLD_SII_MISSING_ERROR_ACK ((TLR_RESULT)0xC0CC0007L)

//
// MessageId: TLR_E_ECMV4_LLD_STATE_CHANGE_FAILED
//
// MessageText:
//
//  LLD: ESM State Change failed.
//
#define TLR_E_ECMV4_LLD_STATE_CHANGE_FAILED ((TLR_RESULT)0xC0CC0008L)

//
// MessageId: TLR_E_ECMV4_LLD_UNEXPECTED_AL_STATUS
//
// MessageText:
//
//  LLD: Unexpected ALSTATUS.
//
#define TLR_E_ECMV4_LLD_UNEXPECTED_AL_STATUS ((TLR_RESULT)0xC0CC0009L)

//
// MessageId: TLR_E_ECMV4_LLD_UNEXPECTED_WKC
//
// MessageText:
//
//  LLD: Unexpected Working Count.
//
#define TLR_E_ECMV4_LLD_UNEXPECTED_WKC   ((TLR_RESULT)0xC0CC000AL)

//
// MessageId: TLR_E_ECMV4_LLD_MAILBOX_NOT_AVAILABLE
//
// MessageText:
//
//  LLD: Mailbox not available.
//
#define TLR_E_ECMV4_LLD_MAILBOX_NOT_AVAILABLE ((TLR_RESULT)0xC0CC000BL)

//
// MessageId: TLR_E_ECMV4_LLD_MAILBOX_MESSAGE_TOO_LARGE
//
// MessageText:
//
//  LLD: Mailbox message too large.
//
#define TLR_E_ECMV4_LLD_MAILBOX_MESSAGE_TOO_LARGE ((TLR_RESULT)0xC0CC000CL)

//
// MessageId: TLR_E_ECMV4_LLD_CONFIGURATION_IN_PROGRESS
//
// MessageText:
//
//  LLD: Configuration in progress.
//
#define TLR_E_ECMV4_LLD_CONFIGURATION_IN_PROGRESS ((TLR_RESULT)0xC0CC000DL)

//
// MessageId: TLR_E_ECMV4_LLD_TOO_MANY_CYCLIC_FRAMES
//
// MessageText:
//
//  LLD: Too many cyclic frames.
//
#define TLR_E_ECMV4_LLD_TOO_MANY_CYCLIC_FRAMES ((TLR_RESULT)0xC0CC000EL)

//
// MessageId: TLR_E_ECMV4_LLD_CYCLIC_FRAME_EXCEEDS_MTU
//
// MessageText:
//
//  LLD: SII Checksum Error.
//
#define TLR_E_ECMV4_LLD_CYCLIC_FRAME_EXCEEDS_MTU ((TLR_RESULT)0xC0CC000FL)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_CYCLIC_TELEGRAM_CONFIG
//
// MessageText:
//
//  LLD: Invalid cyclic telegram config.
//
#define TLR_E_ECMV4_LLD_INVALID_CYCLIC_TELEGRAM_CONFIG ((TLR_RESULT)0xC0CC0010L)

//
// MessageId: TLR_E_ECMV4_LLD_BUILDING_COPY_ROUTINES_FAILED
//
// MessageText:
//
//  LLD: Building copy routines failed.
//
#define TLR_E_ECMV4_LLD_BUILDING_COPY_ROUTINES_FAILED ((TLR_RESULT)0xC0CC0011L)

//
// MessageId: TLR_E_ECMV4_LLD_UNSUPPORTED_SLAVE_STATION_ADDRESS
//
// MessageText:
//
//  LLD: Unsupported slave station address.
//
#define TLR_E_ECMV4_LLD_UNSUPPORTED_SLAVE_STATION_ADDRESS ((TLR_RESULT)0xC0CC0012L)

//
// MessageId: TLR_E_ECMV4_LLD_STATION_ADDRESS_NOT_ALLOWED
//
// MessageText:
//
//  LLD: Station address not allowed.
//
#define TLR_E_ECMV4_LLD_STATION_ADDRESS_NOT_ALLOWED ((TLR_RESULT)0xC0CC0013L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_STD_TX_MBX_PHYS_OFFSET
//
// MessageText:
//
//  LLD: Invalid Std TxMbx PhysOffset.
//
#define TLR_E_ECMV4_LLD_INVALID_STD_TX_MBX_PHYS_OFFSET ((TLR_RESULT)0xC0CC0014L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_STD_RX_MBX_PHYS_OFFSET
//
// MessageText:
//
//  LLD: Invalid Std RxMbx PhysOffset.
//
#define TLR_E_ECMV4_LLD_INVALID_STD_RX_MBX_PHYS_OFFSET ((TLR_RESULT)0xC0CC0015L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_BOOT_TX_MBX_PHYS_OFFSET
//
// MessageText:
//
//  LLD: Invalid Boot TxMbx PhysOffset.
//
#define TLR_E_ECMV4_LLD_INVALID_BOOT_TX_MBX_PHYS_OFFSET ((TLR_RESULT)0xC0CC0016L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_BOOT_RX_MBX_PHYS_OFFSET
//
// MessageText:
//
//  LLD: Invalid Boot RxMbx PhysOffset.
//
#define TLR_E_ECMV4_LLD_INVALID_BOOT_RX_MBX_PHYS_OFFSET ((TLR_RESULT)0xC0CC0017L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_STD_TX_MBX_SM_NO
//
// MessageText:
//
//  LLD: Invalid Std TxMbx SyncManager number.
//
#define TLR_E_ECMV4_LLD_INVALID_STD_TX_MBX_SM_NO ((TLR_RESULT)0xC0CC0018L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_STD_RX_MBX_SM_NO
//
// MessageText:
//
//  LLD: Invalid Std RxMbx SyncManager number.
//
#define TLR_E_ECMV4_LLD_INVALID_STD_RX_MBX_SM_NO ((TLR_RESULT)0xC0CC0019L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_BOOT_TX_MBX_SM_NO
//
// MessageText:
//
//  LLD: Invalid Boot TxMbx SyncManager number.
//
#define TLR_E_ECMV4_LLD_INVALID_BOOT_TX_MBX_SM_NO ((TLR_RESULT)0xC0CC001AL)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_BOOT_RX_MBX_SM_NO
//
// MessageText:
//
//  LLD: Invalid Boot RxMbx SyncManager number.
//
#define TLR_E_ECMV4_LLD_INVALID_BOOT_RX_MBX_SM_NO ((TLR_RESULT)0xC0CC001BL)

//
// MessageId: TLR_E_ECMV4_LLD_UNCONFIGURED_SLAVE_STATION_ADDRESS
//
// MessageText:
//
//  LLD: Unconfigured slave station address.
//
#define TLR_E_ECMV4_LLD_UNCONFIGURED_SLAVE_STATION_ADDRESS ((TLR_RESULT)0xC0CC001CL)

//
// MessageId: TLR_E_ECMV4_LLD_WRONG_SLAVE_STATE
//
// MessageText:
//
//  LLD: Wrong slave state.
//
#define TLR_E_ECMV4_LLD_WRONG_SLAVE_STATE ((TLR_RESULT)0xC0CC001DL)

//
// MessageId: TLR_E_ECMV4_LLD_CYCLE_TIME_TOO_SMALL
//
// MessageText:
//
//  LLD: Cycle time too small.
//
#define TLR_E_ECMV4_LLD_CYCLE_TIME_TOO_SMALL ((TLR_RESULT)0xC0CC001EL)

//
// MessageId: TLR_E_ECMV4_LLD_REPETITION_COUNT_NOT_SUPPORTED
//
// MessageText:
//
//  LLD: Repetition count not supported.
//
#define TLR_E_ECMV4_LLD_REPETITION_COUNT_NOT_SUPPORTED ((TLR_RESULT)0xC0CC001FL)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_CALLBACK_TYPE
//
// MessageText:
//
//  LLD: Invalid callback type.
//
#define TLR_E_ECMV4_LLD_INVALID_CALLBACK_TYPE ((TLR_RESULT)0xC0CC0020L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_CYCLE_MULTIPLIER
//
// MessageText:
//
//  LLD: Invalid cycle multiplier.
//
#define TLR_E_ECMV4_LLD_INVALID_CYCLE_MULTIPLIER ((TLR_RESULT)0xC0CC0021L)

//
// MessageId: TLR_E_ECMV4_LLD_UNKNOWN_ERROR
//
// MessageText:
//
//  LLD: Unknown error.
//
#define TLR_E_ECMV4_LLD_UNKNOWN_ERROR    ((TLR_RESULT)0xC0CC0022L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_REG_LENGTH
//
// MessageText:
//
//  LLD: Invalid register length.
//
#define TLR_E_ECMV4_LLD_INVALID_REG_LENGTH ((TLR_RESULT)0xC0CC0023L)

//
// MessageId: TLR_E_ECMV4_LLD_INVALID_PARAMETER
//
// MessageText:
//
//  LLD: Invalid parameter.
//
#define TLR_E_ECMV4_LLD_INVALID_PARAMETER ((TLR_RESULT)0xC0CC0024L)

//
// MessageId: TLR_E_ECMV4_LLD_IRQ_NOT_AVAILABLE
//
// MessageText:
//
//  LLD: IRQ not available.
//
#define TLR_E_ECMV4_LLD_IRQ_NOT_AVAILABLE ((TLR_RESULT)0xC0CC0025L)

//
// MessageId: TLR_E_ECMV4_LLD_IOMEM_IRQ_NOT_AVAILABLE
//
// MessageText:
//
//  LLD: I/O Mem or IRQ not available.
//
#define TLR_E_ECMV4_LLD_IOMEM_IRQ_NOT_AVAILABLE ((TLR_RESULT)0xC0CC0026L)

//
// MessageId: TLR_E_ECMV4_LLD_HW_INIT_FAILED
//
// MessageText:
//
//  LLD: Hardware init failed.
//
#define TLR_E_ECMV4_LLD_HW_INIT_FAILED   ((TLR_RESULT)0xC0CC0027L)

//
// MessageId: TLR_E_ECMV4_LLD_MUTEX_CREATION_FAILED
//
// MessageText:
//
//  LLD: Mutex creation failed.
//
#define TLR_E_ECMV4_LLD_MUTEX_CREATION_FAILED ((TLR_RESULT)0xC0CC0028L)

//
// MessageId: TLR_E_ECMV4_LLD_DC_RX_LATCH_COMMAND_REQUIRED_FOR_DC
//
// MessageText:
//
//  LLD: DC Rx-Latch command required for DC.
//
#define TLR_E_ECMV4_LLD_DC_RX_LATCH_COMMAND_REQUIRED_FOR_DC ((TLR_RESULT)0xC0CC0029L)

//
// MessageId: TLR_E_ECMV4_LLD_TX_PROCESS_IMAGE_EXCEEDED
//
// MessageText:
//
//  LLD: Tx process image exceeded.
//
#define TLR_E_ECMV4_LLD_TX_PROCESS_IMAGE_EXCEEDED ((TLR_RESULT)0xC0CC002AL)

//
// MessageId: TLR_E_ECMV4_LLD_RX_PROCESS_IMAGE_EXCEEDED
//
// MessageText:
//
//  LLD: Rx process image exceeded.
//
#define TLR_E_ECMV4_LLD_RX_PROCESS_IMAGE_EXCEEDED ((TLR_RESULT)0xC0CC002BL)

//
// MessageId: TLR_E_ECMV4_LLD_MBX_STATE_IMAGE_EXCEEDED
//
// MessageText:
//
//  LLD: MbxState image exceeded.
//
#define TLR_E_ECMV4_LLD_MBX_STATE_IMAGE_EXCEEDED ((TLR_RESULT)0xC0CC002CL)

/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 EMC Error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECMV4_EMC_BUS_IS_OFF
//
// MessageText:
//
//  Bus is off.
//
#define TLR_E_ECMV4_EMC_BUS_IS_OFF       ((TLR_RESULT)0x40CD0017L)

//
// MessageId: TLR_E_ECMV4_EMC_REQUEST_DESTINATION_PROBLEM
//
// MessageText:
//
//  Request destination problem.
//
#define TLR_E_ECMV4_EMC_REQUEST_DESTINATION_PROBLEM ((TLR_RESULT)0xC0CD0001L)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_SLAVE_STATION_ADDRESS
//
// MessageText:
//
//  Invalid slave station address.
//
#define TLR_E_ECMV4_EMC_INVALID_SLAVE_STATION_ADDRESS ((TLR_RESULT)0xC0CD0002L)

//
// MessageId: TLR_E_ECMV4_EMC_CONFIGURATION_BUFFER_IS_OPEN
//
// MessageText:
//
//  Configuration Buffer is open.
//
#define TLR_E_ECMV4_EMC_CONFIGURATION_BUFFER_IS_OPEN ((TLR_RESULT)0xC0CD0003L)

//
// MessageId: TLR_E_ECMV4_EMC_WRONG_STATE_FOR_RECONFIGURATION
//
// MessageText:
//
//  Wrong state for reconfiguration.
//
#define TLR_E_ECMV4_EMC_WRONG_STATE_FOR_RECONFIGURATION ((TLR_RESULT)0xC0CD0004L)

//
// MessageId: TLR_E_ECMV4_EMC_CONFIGURATION_BUFFER_IS_NOT_OPEN
//
// MessageText:
//
//  Configuration Buffer is not open.
//
#define TLR_E_ECMV4_EMC_CONFIGURATION_BUFFER_IS_NOT_OPEN ((TLR_RESULT)0xC0CD0005L)

//
// MessageId: TLR_E_ECMV4_EMC_SLAVE_STATION_ADDRESS_ALREADY_IN_CONFIG
//
// MessageText:
//
//  Slave station address is already in configuration.
//
#define TLR_E_ECMV4_EMC_SLAVE_STATION_ADDRESS_ALREADY_IN_CONFIG ((TLR_RESULT)0xC0CD0006L)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_STD_MBX_PARAMETERS
//
// MessageText:
//
//  Invalid Std Mbx parameters.
//
#define TLR_E_ECMV4_EMC_INVALID_STD_MBX_PARAMETERS ((TLR_RESULT)0xC0CD0007L)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_BOOT_MBX_PARAMETERS
//
// MessageText:
//
//  Invalid Boot Mbx parameters.
//
#define TLR_E_ECMV4_EMC_INVALID_BOOT_MBX_PARAMETERS ((TLR_RESULT)0xC0CD0008L)

//
// MessageId: TLR_E_ECMV4_EMC_STD_MBX_SM_ARE_OVERLAPPING
//
// MessageText:
//
//  Std Mbx SyncManagers are overlapping.
//
#define TLR_E_ECMV4_EMC_STD_MBX_SM_ARE_OVERLAPPING ((TLR_RESULT)0xC0CD0009L)

//
// MessageId: TLR_E_ECMV4_EMC_BOOT_MBX_SM_ARE_OVERLAPPING
//
// MessageText:
//
//  Boot Mbx SyncManagers are overlapping.
//
#define TLR_E_ECMV4_EMC_BOOT_MBX_SM_ARE_OVERLAPPING ((TLR_RESULT)0xC0CD000AL)

//
// MessageId: TLR_E_ECMV4_EMC_SM_PARAMS_ALREADY_ADDED
//
// MessageText:
//
//  SyncManager params already added.
//
#define TLR_E_ECMV4_EMC_SM_PARAMS_ALREADY_ADDED ((TLR_RESULT)0xC0CD000BL)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_SM_NUMBER
//
// MessageText:
//
//  Invalid SyncManager number.
//
#define TLR_E_ECMV4_EMC_INVALID_SM_NUMBER ((TLR_RESULT)0xC0CD000CL)

//
// MessageId: TLR_E_ECMV4_EMC_FMMU_PARAMS_ALREADY_ADDED
//
// MessageText:
//
//  FMMU params already added.
//
#define TLR_E_ECMV4_EMC_FMMU_PARAMS_ALREADY_ADDED ((TLR_RESULT)0xC0CD000DL)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_FMMU_NUMBER
//
// MessageText:
//
//  Invalid FMMU number.
//
#define TLR_E_ECMV4_EMC_INVALID_FMMU_NUMBER ((TLR_RESULT)0xC0CD000EL)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_MIN_STATE
//
// MessageText:
//
//  Invalid Min State.
//
#define TLR_E_ECMV4_EMC_INVALID_MIN_STATE ((TLR_RESULT)0xC0CD000FL)

//
// MessageId: TLR_E_ECMV4_EMC_CYCLE_FRAME_AMOUNT_EXCEEDED
//
// MessageText:
//
//  Cycle frame amount exceeded.
//
#define TLR_E_ECMV4_EMC_CYCLE_FRAME_AMOUNT_EXCEEDED ((TLR_RESULT)0xC0CD0010L)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_CYCLIC_FRAME_IN_CONFIGURATION
//
// MessageText:
//
//  Invalid cyclic frame in configuration.
//
#define TLR_E_ECMV4_EMC_INVALID_CYCLIC_FRAME_IN_CONFIGURATION ((TLR_RESULT)0xC0CD0011L)

//
// MessageId: TLR_E_ECMV4_EMC_CYCLE_FRAME_INDEX_NOT_VALID
//
// MessageText:
//
//  Cycle frame index not valid.
//
#define TLR_E_ECMV4_EMC_CYCLE_FRAME_INDEX_NOT_VALID ((TLR_RESULT)0xC0CD0012L)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_TELEGRAM_LENGTH
//
// MessageText:
//
//  Invalid telegram length.
//
#define TLR_E_ECMV4_EMC_INVALID_TELEGRAM_LENGTH ((TLR_RESULT)0xC0CD0013L)

//
// MessageId: TLR_E_ECMV4_EMC_CYCLE_FRAME_LENGTH_EXCEEDED
//
// MessageText:
//
//  Cycle frame length exceeded.
//
#define TLR_E_ECMV4_EMC_CYCLE_FRAME_LENGTH_EXCEEDED ((TLR_RESULT)0xC0CD0014L)

//
// MessageId: TLR_E_ECMV4_EMC_AMOUNT_OF_TELEGRAMS_IN_CYCLIC_FRAMES_EXCEEDED
//
// MessageText:
//
//  Amount of telegrams in cyclic frame exceeded.
//
#define TLR_E_ECMV4_EMC_AMOUNT_OF_TELEGRAMS_IN_CYCLIC_FRAMES_EXCEEDED ((TLR_RESULT)0xC0CD0015L)

//
// MessageId: TLR_E_ECMV4_EMC_STATE_CHANGE_IN_PROGRESS
//
// MessageText:
//
//  State change in progress.
//
#define TLR_E_ECMV4_EMC_STATE_CHANGE_IN_PROGRESS ((TLR_RESULT)0xC0CD0016L)

//
// MessageId: TLR_E_ECMV4_EMC_TOO_MANY_SLAVES_GIVEN
//
// MessageText:
//
//  Too many slaves given.
//
#define TLR_E_ECMV4_EMC_TOO_MANY_SLAVES_GIVEN ((TLR_RESULT)0xC0CD0018L)

//
// MessageId: TLR_E_ECMV4_EMC_DUPLICATE_STATION_ADDRESS_IN_LIST
//
// MessageText:
//
//  Duplicate station address in list.
//
#define TLR_E_ECMV4_EMC_DUPLICATE_STATION_ADDRESS_IN_LIST ((TLR_RESULT)0xC0CD0019L)

//
// MessageId: TLR_E_ECMV4_EMC_CONFIGURATION_DATA_INCORRECT
//
// MessageText:
//
//  Configuration data incorrect.
//
#define TLR_E_ECMV4_EMC_CONFIGURATION_DATA_INCORRECT ((TLR_RESULT)0xC0CD001BL)

//
// MessageId: TLR_E_ECMV4_EMC_VENDORID_MISMATCH
//
// MessageText:
//
//  Vendor Id mismatch.
//
#define TLR_E_ECMV4_EMC_VENDORID_MISMATCH ((TLR_RESULT)0xC0CD001CL)

//
// MessageId: TLR_E_ECMV4_EMC_PRODUCTCODE_MISMATCH
//
// MessageText:
//
//  Product Code mismatch.
//
#define TLR_E_ECMV4_EMC_PRODUCTCODE_MISMATCH ((TLR_RESULT)0xC0CD001DL)

//
// MessageId: TLR_E_ECMV4_EMC_REVISIONNO_MISMATCH
//
// MessageText:
//
//  Revision Number mismatch.
//
#define TLR_E_ECMV4_EMC_REVISIONNO_MISMATCH ((TLR_RESULT)0xC0CD001EL)

//
// MessageId: TLR_E_ECMV4_EMC_SERIALNO_MISMATCH
//
// MessageText:
//
//  Serial Number mismatch.
//
#define TLR_E_ECMV4_EMC_SERIALNO_MISMATCH ((TLR_RESULT)0xC0CD001FL)

//
// MessageId: TLR_E_ECMV4_EMC_LOST_CONNECTION
//
// MessageText:
//
//  Lost Connection.
//
#define TLR_E_ECMV4_EMC_LOST_CONNECTION  ((TLR_RESULT)0xC0CD0020L)

//
// MessageId: TLR_E_ECMV4_EMC_UNKNOWN_STATE_CHANGE_HAPPENED
//
// MessageText:
//
//  Unknown state change happened.
//
#define TLR_E_ECMV4_EMC_UNKNOWN_STATE_CHANGE_HAPPENED ((TLR_RESULT)0xC0CD0021L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_STATE_CHANGE_HAPPENED
//
// MessageText:
//
//  Unexpected state change happened.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_STATE_CHANGE_HAPPENED ((TLR_RESULT)0xC0CD0022L)

//
// MessageId: TLR_E_ECMV4_EMC_SLAVE_CHANGED_STATE
//
// MessageText:
//
//  Slave changed state.
//
#define TLR_E_ECMV4_EMC_SLAVE_CHANGED_STATE ((TLR_RESULT)0xC0CD0023L)

//
// MessageId: TLR_E_ECMV4_EMC_FILE_PROVIDER_INIT_FAILED
//
// MessageText:
//
//  File Provider init failed.
//
#define TLR_E_ECMV4_EMC_FILE_PROVIDER_INIT_FAILED ((TLR_RESULT)0xC0CD0024L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_TIMESTAMP_ERROR
//
// MessageText:
//
//  DC Rx Timestamp Error.
//
#define TLR_E_ECMV4_EMC_DC_RX_TIMESTAMP_ERROR ((TLR_RESULT)0xC0CD0026L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_MASTER_PORT_TIMESTAMP_ERROR
//
// MessageText:
//
//  DC Master Port Timestamp Error.
//
#define TLR_E_ECMV4_EMC_DC_MASTER_PORT_TIMESTAMP_ERROR ((TLR_RESULT)0xC0CD0027L)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_SLAVE_INDEX
//
// MessageText:
//
//  Invalid slave index.
//
#define TLR_E_ECMV4_EMC_INVALID_SLAVE_INDEX ((TLR_RESULT)0xC0CD0028L)

//
// MessageId: TLR_E_ECMV4_EMC_WRONG_MASTER_STATE
//
// MessageText:
//
//  Wrong master state.
//
#define TLR_E_ECMV4_EMC_WRONG_MASTER_STATE ((TLR_RESULT)0xC0CD0029L)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_TRANSFER_ID
//
// MessageText:
//
//  Invalid transfer id.
//
#define TLR_E_ECMV4_EMC_INVALID_TRANSFER_ID ((TLR_RESULT)0xC0CD002AL)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_SEGMENTATION
//
// MessageText:
//
//  Invalid segmentation.
//
#define TLR_E_ECMV4_EMC_INVALID_SEGMENTATION ((TLR_RESULT)0xC0CD002BL)

//
// MessageId: TLR_E_ECMV4_EMC_EOE_IP_PARAMS_ALREADY_ADDED
//
// MessageText:
//
//  EoE IP Parameter already added.
//
#define TLR_E_ECMV4_EMC_EOE_IP_PARAMS_ALREADY_ADDED ((TLR_RESULT)0xC0CD002CL)

//
// MessageId: TLR_E_ECMV4_EMC_EOE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  EoE Support not available.
//
#define TLR_E_ECMV4_EMC_EOE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0CD002DL)

//
// MessageId: TLR_E_ECMV4_EMC_END_CONFIGURATION_IN_PROGRESS
//
// MessageText:
//
//  End configuration in progress.
//
#define TLR_E_ECMV4_EMC_END_CONFIGURATION_IN_PROGRESS ((TLR_RESULT)0xC0CD002EL)

//
// MessageId: TLR_E_ECMV4_EMC_WRONG_STATE_FOR_RECONFIGURATION_BUS_IS_ON
//
// MessageText:
//
//  Wrong state for reconfiguration: Bus Is On.
//
#define TLR_E_ECMV4_EMC_WRONG_STATE_FOR_RECONFIGURATION_BUS_IS_ON ((TLR_RESULT)0xC0CD002FL)

//
// MessageId: TLR_E_ECMV4_EMC_WRONG_STATE_FOR_RECONFIGURATION_BUS_SCAN_ACTIVE
//
// MessageText:
//
//  Wrong state for reconfiguration: Bus Scan is active.
//
#define TLR_E_ECMV4_EMC_WRONG_STATE_FOR_RECONFIGURATION_BUS_SCAN_ACTIVE ((TLR_RESULT)0xC0CD0030L)

//
// MessageId: TLR_E_ECMV4_EMC_WRONG_STATE_FOR_RECONFIGURATION_IN_PROGRESS_TO_BUSOFF
//
// MessageText:
//
//  Wrong state for reconfiguration: Bus Off in progress.
//
#define TLR_E_ECMV4_EMC_WRONG_STATE_FOR_RECONFIGURATION_IN_PROGRESS_TO_BUSOFF ((TLR_RESULT)0xC0CD0031L)

//
// MessageId: TLR_E_ECMV4_EMC_NO_DIAG_ENTRY_AVAILABLE
//
// MessageText:
//
//  No diag entry available.
//
#define TLR_E_ECMV4_EMC_NO_DIAG_ENTRY_AVAILABLE ((TLR_RESULT)0xC0CD0032L)

//
// MessageId: TLR_E_ECMV4_EMC_SLAVE_SYNC_PARAMS_NOT_POSSIBLE_WITHOUT_WORKING_DC
//
// MessageText:
//
//  Slave Sync parameters are not possible without working DC.
//
#define TLR_E_ECMV4_EMC_SLAVE_SYNC_PARAMS_NOT_POSSIBLE_WITHOUT_WORKING_DC ((TLR_RESULT)0xC0CD0033L)

//
// MessageId: TLR_E_ECMV4_EMC_MANDATORY_SLAVE_MISSING
//
// MessageText:
//
//  Mandatory slave missing.
//
#define TLR_E_ECMV4_EMC_MANDATORY_SLAVE_MISSING ((TLR_RESULT)0xC0CD0034L)

//
// MessageId: TLR_E_ECMV4_EMC_WRONG_SLAVE_AT_POSITION
//
// MessageText:
//
//  Wrong slave at position.
//
#define TLR_E_ECMV4_EMC_WRONG_SLAVE_AT_POSITION ((TLR_RESULT)0xC0CD0035L)

//
// MessageId: TLR_E_ECMV4_EMC_NO_DC_REF_CLOCK
//
// MessageText:
//
//  No DC Reference clock available.
//
#define TLR_E_ECMV4_EMC_NO_DC_REF_CLOCK  ((TLR_RESULT)0xC0CD0036L)

//
// MessageId: TLR_E_ECMV4_EMC_INVALID_DC_REF_CLOCK
//
// MessageText:
//
//  Invalid DC reference clock.
//
#define TLR_E_ECMV4_EMC_INVALID_DC_REF_CLOCK ((TLR_RESULT)0xC0CD0038L)

//
// MessageId: TLR_E_ECMV4_EMC_COE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  CoE Support not available.
//
#define TLR_E_ECMV4_EMC_COE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0CD0039L)

//
// MessageId: TLR_E_ECMV4_EMC_SOE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  SoE Support not available.
//
#define TLR_E_ECMV4_EMC_SOE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0CD003AL)

//
// MessageId: TLR_E_ECMV4_EMC_FOE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  FoE Support not available.
//
#define TLR_E_ECMV4_EMC_FOE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0CD003BL)

//
// MessageId: TLR_E_ECMV4_EMC_AOE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  AoE Support not available.
//
#define TLR_E_ECMV4_EMC_AOE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0CD003CL)

//
// MessageId: TLR_E_ECMV4_EMC_RECONNECTED
//
// MessageText:
//
//  Slave reconnected.
//
#define TLR_E_ECMV4_EMC_RECONNECTED      ((TLR_RESULT)0x40CD003EL)

//
// MessageId: TLR_E_ECMV4_EMC_DC_STOPPED
//
// MessageText:
//
//  DC ARMW/FRMW has been stopped.
//
#define TLR_E_ECMV4_EMC_DC_STOPPED       ((TLR_RESULT)0x80CD003FL)

//
// MessageId: TLR_E_ECMV4_EMC_STOPPED_DUE_SYNC_ERROR
//
// MessageText:
//
//  Stopped due sync error.
//
#define TLR_E_ECMV4_EMC_STOPPED_DUE_SYNC_ERROR ((TLR_RESULT)0xC0CD0040L)

//
// MessageId: TLR_E_ECMV4_EMC_MANDATORY_SLAVE_NOT_IN_OP
//
// MessageText:
//
//  Mandatory slave is not in OP.
//
#define TLR_E_ECMV4_EMC_MANDATORY_SLAVE_NOT_IN_OP ((TLR_RESULT)0xC0CD0041L)

//
// MessageId: TLR_E_ECMV4_EMC_BUS_CYCLE_TIME_NOT_POSSIBLE
//
// MessageText:
//
//  Bus cycle time not possible.
//
#define TLR_E_ECMV4_EMC_BUS_CYCLE_TIME_NOT_POSSIBLE ((TLR_RESULT)0xC0CD0042L)

//
// MessageId: TLR_E_ECMV4_EMC_TOPOLOGY_ERROR_DETECTED
//
// MessageText:
//
//  Topology error detected.
//
#define TLR_E_ECMV4_EMC_TOPOLOGY_ERROR_DETECTED ((TLR_RESULT)0xC0CD0043L)

//
// MessageId: TLR_E_ECMV4_EMC_TOPOLOGY_MISMATCH_DETECTED
//
// MessageText:
//
//  Topology mismatch detected.
//
#define TLR_E_ECMV4_EMC_TOPOLOGY_MISMATCH_DETECTED ((TLR_RESULT)0xC0CD0044L)

//
// MessageId: TLR_E_ECMV4_EMC_NO_VALID_TOPOLOGY_CONFIGURATION_DATA
//
// MessageText:
//
//  No valid topology configuration data.
//
#define TLR_E_ECMV4_EMC_NO_VALID_TOPOLOGY_CONFIGURATION_DATA ((TLR_RESULT)0xC0CD0045L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0
//
// MessageText:
//
//  Unexpected slave at port 0.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0 ((TLR_RESULT)0xC0CD0046L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT1
//
// MessageText:
//
//  Unexpected slave at port 1.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT1 ((TLR_RESULT)0xC0CD0047L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT2
//
// MessageText:
//
//  Unexpected slave at port 2.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT2 ((TLR_RESULT)0xC0CD0048L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT3
//
// MessageText:
//
//  Unexpected slave at port 3.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT3 ((TLR_RESULT)0xC0CD0049L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_CONNECTED
//
// MessageText:
//
//  Unexpected slave connected.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_CONNECTED ((TLR_RESULT)0xC0CD004AL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0
//
// MessageText:
//
//  Missing slave at port 0.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0 ((TLR_RESULT)0xC0CD004BL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT1
//
// MessageText:
//
//  Missing slave at port 1.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT1 ((TLR_RESULT)0xC0CD004CL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT2
//
// MessageText:
//
//  Missing slave at port 2.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT2 ((TLR_RESULT)0xC0CD004DL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT3
//
// MessageText:
//
//  Missing slave at port 3.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT3 ((TLR_RESULT)0xC0CD004EL)

//
// MessageId: TLR_E_ECMV4_EMC_SLAVE_NOT_CHECKED
//
// MessageText:
//
//  Slave not checked.
//
#define TLR_E_ECMV4_EMC_SLAVE_NOT_CHECKED ((TLR_RESULT)0xC0CD004FL)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_1
//
// MessageText:
//
//  Unexpected slaves at ports 0 and 1.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_1 ((TLR_RESULT)0xC0CD0050L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_2
//
// MessageText:
//
//  Unexpected slaves at ports 0 and 2.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_2 ((TLR_RESULT)0xC0CD0051L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_3
//
// MessageText:
//
//  Unexpected slaves at ports 0 and 3.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_3 ((TLR_RESULT)0xC0CD0052L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT1_2
//
// MessageText:
//
//  Unexpected slaves at ports 1 and 2.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT1_2 ((TLR_RESULT)0xC0CD0053L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT1_3
//
// MessageText:
//
//  Unexpected slaves at ports 1 and 3.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT1_3 ((TLR_RESULT)0xC0CD0054L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT2_3
//
// MessageText:
//
//  Unexpected slaves at ports 2 and 3.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT2_3 ((TLR_RESULT)0xC0CD0055L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_1_2
//
// MessageText:
//
//  Unexpected slaves at ports 0, 1 and 2.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_1_2 ((TLR_RESULT)0xC0CD0056L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_1_3
//
// MessageText:
//
//  Unexpected slaves at ports 0, 1 and 3.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_1_3 ((TLR_RESULT)0xC0CD0057L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_2_3
//
// MessageText:
//
//  Unexpected slaves at ports 0, 2 and 3.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT0_2_3 ((TLR_RESULT)0xC0CD0058L)

//
// MessageId: TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT1_2_3
//
// MessageText:
//
//  Unexpected slaves at ports 1, 2 and 3.
//
#define TLR_E_ECMV4_EMC_UNEXPECTED_SLAVE_AT_PORT1_2_3 ((TLR_RESULT)0xC0CD0059L)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_1
//
// MessageText:
//
//  Missing slaves at ports 0 and 1.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_1 ((TLR_RESULT)0xC0CD005AL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_2
//
// MessageText:
//
//  Missing slaves at ports 0 and 2.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_2 ((TLR_RESULT)0xC0CD005BL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_3
//
// MessageText:
//
//  Missing slaves at ports 0 and 3.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_3 ((TLR_RESULT)0xC0CD005CL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT1_2
//
// MessageText:
//
//  Missing slaves at ports 1 and 2.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT1_2 ((TLR_RESULT)0xC0CD005DL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT1_3
//
// MessageText:
//
//  Missing slaves at ports 1 and 3.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT1_3 ((TLR_RESULT)0xC0CD005EL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT2_3
//
// MessageText:
//
//  Missing slaves at ports 2 and 3.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT2_3 ((TLR_RESULT)0xC0CD005FL)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_1_2
//
// MessageText:
//
//  Missing slaves at ports 0, 1 and 2.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_1_2 ((TLR_RESULT)0xC0CD0060L)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_1_3
//
// MessageText:
//
//  Missing slaves at ports 0, 1 and 3.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_1_3 ((TLR_RESULT)0xC0CD0061L)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_2_3
//
// MessageText:
//
//  Missing slaves at ports 0, 2 and 3.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT0_2_3 ((TLR_RESULT)0xC0CD0062L)

//
// MessageId: TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT1_2_3
//
// MessageText:
//
//  Missing slaves at ports 1, 2 and 3.
//
#define TLR_E_ECMV4_EMC_MISSING_SLAVE_AT_PORT1_2_3 ((TLR_RESULT)0xC0CD0063L)

//
// MessageId: TLR_E_ECMV4_EMC_HC_PARTICIPANT_NOT_ALLOWED_IN_MANDATORY_SLAVE_LIST
//
// MessageText:
//
//  Hot Connect participant is not allowed in mandatory slave list.
//
#define TLR_E_ECMV4_EMC_HC_PARTICIPANT_NOT_ALLOWED_IN_MANDATORY_SLAVE_LIST ((TLR_RESULT)0xC0CD0065L)

//
// MessageId: TLR_E_ECMV4_EMC_HC_PARTICIPANT_NOT_ALLOWED_IN_MULTIPLE_HC_GROUPS
//
// MessageText:
//
//  Hot Connect participant is not allowed in multiple Hot Connect groups.
//
#define TLR_E_ECMV4_EMC_HC_PARTICIPANT_NOT_ALLOWED_IN_MULTIPLE_HC_GROUPS ((TLR_RESULT)0xC0CD0066L)

//
// MessageId: TLR_E_ECMV4_EMC_HC_GROUP_HEAD_IS_NOT_LISTED_FOR_HC_DETECTION
//
// MessageText:
//
//  Hot Connect Group Head is not listed for Hot Connect detection.
//
#define TLR_E_ECMV4_EMC_HC_GROUP_HEAD_IS_NOT_LISTED_FOR_HC_DETECTION ((TLR_RESULT)0xC0CD0067L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_SETUP_CALCULATION_ERROR
//
// MessageText:
//
//  DC Setup calculation error.
//
#define TLR_E_ECMV4_EMC_DC_SETUP_CALCULATION_ERROR ((TLR_RESULT)0xC0CD0068L)

//
// MessageId: TLR_E_ECMV4_EMC_NON_DC_SLAVE_MORE_THAN_2_PORTS_IN_DC_SETUP
//
// MessageText:
//
//  A Slave without DC support has more than 2 ports in DC setup.
//
#define TLR_E_ECMV4_EMC_NON_DC_SLAVE_MORE_THAN_2_PORTS_IN_DC_SETUP ((TLR_RESULT)0xC0CD0069L)

//
// MessageId: TLR_E_ECMV4_EMC_HC_GROUP_CONTAINS_NOT_CONFIGURED_SLAVE
//
// MessageText:
//
//  Hot Connect Group contains not configured slave.
//
#define TLR_E_ECMV4_EMC_HC_GROUP_CONTAINS_NOT_CONFIGURED_SLAVE ((TLR_RESULT)0xC0CD006AL)

//
// MessageId: TLR_E_ECMV4_EMC_ALCONTROL_TIMEOUT
//
// MessageText:
//
//  ALControl Timeout.
//
#define TLR_E_ECMV4_EMC_ALCONTROL_TIMEOUT ((TLR_RESULT)0xC0CD006BL)

//
// MessageId: TLR_E_ECMV4_EMC_DC_MEASUREMENT_ERROR
//
// MessageText:
//
//  DC Measurement Error.
//
#define TLR_E_ECMV4_EMC_DC_MEASUREMENT_ERROR ((TLR_RESULT)0xC0CD006CL)

//
// MessageId: TLR_E_ECMV4_EMC_RX_DESTINATION_EXCEEDS_RX_IMAGE_SIZE
//
// MessageText:
//
//  Rx Process data destination exceeds Rx Image Size.
//
#define TLR_E_ECMV4_EMC_RX_DESTINATION_EXCEEDS_RX_IMAGE_SIZE ((TLR_RESULT)0xC0CD006DL)

//
// MessageId: TLR_E_ECMV4_EMC_TX_SOURCE_EXCEEDS_TX_IMAGE_SIZE
//
// MessageText:
//
//  Tx Process data source exceeds Tx image Size.
//
#define TLR_E_ECMV4_EMC_TX_SOURCE_EXCEEDS_TX_IMAGE_SIZE ((TLR_RESULT)0xC0CD006EL)

//
// MessageId: TLR_E_ECMV4_EMC_WCSTATEBIT_EXCEEDS_RX_IMAGE_SIZE
//
// MessageText:
//
//  WcState bit exceeds Rx Image Size.
//
#define TLR_E_ECMV4_EMC_WCSTATEBIT_EXCEEDS_RX_IMAGE_SIZE ((TLR_RESULT)0xC0CD006FL)

//
// MessageId: TLR_E_ECMV4_EMC_WKC_MAPPING_EXCEEDS_RX_IMAGE_SIZE
//
// MessageText:
//
//  WKC mapping exceeds Rx Image Size.
//
#define TLR_E_ECMV4_EMC_WKC_MAPPING_EXCEEDS_RX_IMAGE_SIZE ((TLR_RESULT)0xC0CD0070L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0
//
// MessageText:
//
//  DC Rx-Latch Error at Port 0.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0 ((TLR_RESULT)0xC0CD0071L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT1
//
// MessageText:
//
//  DC Rx-Latch Error at Port 1.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT1 ((TLR_RESULT)0xC0CD0072L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT2
//
// MessageText:
//
//  DC Rx-Latch Error at Port 2.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT2 ((TLR_RESULT)0xC0CD0073L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT3
//
// MessageText:
//
//  DC Rx-Latch Error at Port 3.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT3 ((TLR_RESULT)0xC0CD0074L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 0 and 1.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1 ((TLR_RESULT)0xC0CD0075L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_2
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 0 and 2.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_2 ((TLR_RESULT)0xC0CD0076L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_3
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 0 and 3.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_3 ((TLR_RESULT)0xC0CD0077L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT1_2
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 1 and 2.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT1_2 ((TLR_RESULT)0xC0CD0078L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT1_3
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 1 and 3.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT1_3 ((TLR_RESULT)0xC0CD0079L)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT2_3
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 2 and 3.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT2_3 ((TLR_RESULT)0xC0CD007AL)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_2
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 0, 1 and 2.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_2 ((TLR_RESULT)0xC0CD007BL)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_3
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 0, 1 and 3.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_3 ((TLR_RESULT)0xC0CD007CL)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_2_3
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 0, 2 and 3.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_2_3 ((TLR_RESULT)0xC0CD007DL)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT1_2_3
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 1, 2 and 3.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT1_2_3 ((TLR_RESULT)0xC0CD007EL)

//
// MessageId: TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_2_3
//
// MessageText:
//
//  DC Rx-Latch Error at Ports 0, 1, 2 and 3.
//
#define TLR_E_ECMV4_EMC_DC_RX_LATCH_ERROR_AT_PORT0_1_2_3 ((TLR_RESULT)0xC0CD007FL)

/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 CoE Error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECMV4_COE_INITIALIZATION_ERROR
//
// MessageText:
//
//  CoE Initialization Error.
//
#define TLR_E_ECMV4_COE_INITIALIZATION_ERROR ((TLR_RESULT)0xC0CF0001L)

//
// MessageId: TLR_E_ECMV4_COE_INVALID_TRANSFER_HANDLE
//
// MessageText:
//
//  CoE Invalid transfer handle.
//
#define TLR_E_ECMV4_COE_INVALID_TRANSFER_HANDLE ((TLR_RESULT)0xC0CF0002L)

//
// MessageId: TLR_E_ECMV4_COE_NO_MAILBOX_AVAILABLE
//
// MessageText:
//
//  CoE Mailbox not available.
//
#define TLR_E_ECMV4_COE_NO_MAILBOX_AVAILABLE ((TLR_RESULT)0xC0CF0003L)

//
// MessageId: TLR_E_ECMV4_COE_INVALID_TRANSFER_STATE
//
// MessageText:
//
//  CoE Invalid transfer state.
//
#define TLR_E_ECMV4_COE_INVALID_TRANSFER_STATE ((TLR_RESULT)0xC0CF0004L)

//
// MessageId: TLR_E_ECMV4_COE_TRANSFER_SEGMENT_TOO_LONG
//
// MessageText:
//
//  CoE Transfer-Segment too long.
//
#define TLR_E_ECMV4_COE_TRANSFER_SEGMENT_TOO_LONG ((TLR_RESULT)0xC0CF0005L)

//
// MessageId: TLR_E_ECMV4_COE_SHUTTING_DOWN
//
// MessageText:
//
//  CoE Shutting Down.
//
#define TLR_E_ECMV4_COE_SHUTTING_DOWN    ((TLR_RESULT)0xC0CF0006L)

//
// MessageId: TLR_E_ECMV4_COE_MAX_TOTAL_BYTES_SMALLER_THAN_ACTUAL_TOTAL_BYTES
//
// MessageText:
//
//  CoE Max Total Bytes is smaller than Actual Total Bytes.
//
#define TLR_E_ECMV4_COE_MAX_TOTAL_BYTES_SMALLER_THAN_ACTUAL_TOTAL_BYTES ((TLR_RESULT)0xC0CF0007L)

//
// MessageId: TLR_E_ECMV4_COE_MAILBOX_TRANSMIT_FAILED
//
// MessageText:
//
//  CoE Mailbox transmit failed.
//
#define TLR_E_ECMV4_COE_MAILBOX_TRANSMIT_FAILED ((TLR_RESULT)0xC0CF0008L)

//
// MessageId: TLR_E_ECMV4_COE_TRANSFER_ABORTED
//
// MessageText:
//
//  CoE Transfer aborted.
//
#define TLR_E_ECMV4_COE_TRANSFER_ABORTED ((TLR_RESULT)0xC0CF0009L)

//
// MessageId: TLR_E_ECMV4_COE_SDOINFO_INITIALIZATION_ERROR
//
// MessageText:
//
//  CoE SDOINFO Initialization error.
//
#define TLR_E_ECMV4_COE_SDOINFO_INITIALIZATION_ERROR ((TLR_RESULT)0xC0CF000AL)

//
// MessageId: TLR_E_ECMV4_COE_WRONG_SLAVE_STATE
//
// MessageText:
//
//  CoE: Wrong slave state.
//
#define TLR_E_ECMV4_COE_WRONG_SLAVE_STATE ((TLR_RESULT)0xC0CF000BL)

//
// MessageId: TLR_E_ECMV4_COE_PROTOCOL_ERROR
//
// MessageText:
//
//  CoE Protocol Error.
//
#define TLR_E_ECMV4_COE_PROTOCOL_ERROR   ((TLR_RESULT)0xC0CF000CL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_TOGGLE_BIT_NOT_ALTERNATED
//
// MessageText:
//
//  Toggle bit was not changed.
//
#define TLR_E_ECMV4_COE_ABORTCODE_TOGGLE_BIT_NOT_ALTERNATED ((TLR_RESULT)0xC0CF8000L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_COMMAND_SPECIFIER_NOT_VALID
//
// MessageText:
//
//  Client/Server command specifier not valid or unknown.
//
#define TLR_E_ECMV4_COE_ABORTCODE_COMMAND_SPECIFIER_NOT_VALID ((TLR_RESULT)0xC0CF8001L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_PROTOCOL_TIMEOUT
//
// MessageText:
//
//  SDO protocol timeout.
//
#define TLR_E_ECMV4_COE_ABORTCODE_PROTOCOL_TIMEOUT ((TLR_RESULT)0xC0CF8002L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_OUT_OF_MEMORY
//
// MessageText:
//
//  Out of memory.
//
#define TLR_E_ECMV4_COE_ABORTCODE_OUT_OF_MEMORY ((TLR_RESULT)0xC0CF8003L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_UNSUPPORTED_ACCESS
//
// MessageText:
//
//  Unsupported access to an object.
//
#define TLR_E_ECMV4_COE_ABORTCODE_UNSUPPORTED_ACCESS ((TLR_RESULT)0xC0CF8004L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_OBJECT_IS_WRITE_ONLY
//
// MessageText:
//
//  Attempt to read a write only object.
//
#define TLR_E_ECMV4_COE_ABORTCODE_OBJECT_IS_WRITE_ONLY ((TLR_RESULT)0xC0CF8005L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_OBJECT_IS_READ_ONLY
//
// MessageText:
//
//  Attempt to write to a read only object.
//
#define TLR_E_ECMV4_COE_ABORTCODE_OBJECT_IS_READ_ONLY ((TLR_RESULT)0xC0CF8006L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_SUBINDEX_CANNOT_BE_WRITTEN_SI0_NZ
//
// MessageText:
//
//  Subindex cannot be written, Subindex 0 must be 0 for write access.
//
#define TLR_E_ECMV4_COE_ABORTCODE_SUBINDEX_CANNOT_BE_WRITTEN_SI0_NZ ((TLR_RESULT)0xC0CF8007L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_COMPLETE_ACCESS_NOT_SUPPORTED
//
// MessageText:
//
//  Complete Access not supported.
//
#define TLR_E_ECMV4_COE_ABORTCODE_COMPLETE_ACCESS_NOT_SUPPORTED ((TLR_RESULT)0xC0CF8008L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_OBJECT_LENGTH_EXCEEDS_MAILBOX_SIZE
//
// MessageText:
//
//  Object length exceeds mailbox size.
//
#define TLR_E_ECMV4_COE_ABORTCODE_OBJECT_LENGTH_EXCEEDS_MAILBOX_SIZE ((TLR_RESULT)0xC0CF8009L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_OBJECT_MAPPED_TO_RXPDO_NO_WRITE
//
// MessageText:
//
//  Object mapped to RxPDO. SDO Download blocked.
//
#define TLR_E_ECMV4_COE_ABORTCODE_OBJECT_MAPPED_TO_RXPDO_NO_WRITE ((TLR_RESULT)0xC0CF800AL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_OBJECT_DOES_NOT_EXIST
//
// MessageText:
//
//  The object does not exist in the object dictionary.
//
#define TLR_E_ECMV4_COE_ABORTCODE_OBJECT_DOES_NOT_EXIST ((TLR_RESULT)0xC0CF800BL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_OBJECT_CANNOT_BE_PDO_MAPPED
//
// MessageText:
//
//  The object can not be mapped into the PDO.
//
#define TLR_E_ECMV4_COE_ABORTCODE_OBJECT_CANNOT_BE_PDO_MAPPED ((TLR_RESULT)0xC0CF800CL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_PDO_LENGTH_WOULD_EXCEED
//
// MessageText:
//
//  The number and length of the objects to be mapped would exceed the PDO length.
//
#define TLR_E_ECMV4_COE_ABORTCODE_PDO_LENGTH_WOULD_EXCEED ((TLR_RESULT)0xC0CF800DL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_GEN_PARAM_INCOMPATIBILITY
//
// MessageText:
//
//  General parameter incompatibility reason.
//
#define TLR_E_ECMV4_COE_ABORTCODE_GEN_PARAM_INCOMPATIBILITY ((TLR_RESULT)0xC0CF800EL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_ACCESS_FAILED_DUE_TO_HW_ERROR
//
// MessageText:
//
//  Access failed due to a hardware error.
//
#define TLR_E_ECMV4_COE_ABORTCODE_ACCESS_FAILED_DUE_TO_HW_ERROR ((TLR_RESULT)0xC0CF800FL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_DATATYPE_DOES_NOT_MATCH
//
// MessageText:
//
//  Data type does not match, length of service parameter does not match.
//
#define TLR_E_ECMV4_COE_ABORTCODE_DATATYPE_DOES_NOT_MATCH ((TLR_RESULT)0xC0CF8010L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_DATATYPE_LENGTH_TOO_LONG
//
// MessageText:
//
//  Data type does not match, length of service parameter too high.
//
#define TLR_E_ECMV4_COE_ABORTCODE_DATATYPE_LENGTH_TOO_LONG ((TLR_RESULT)0xC0CF8011L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_DATATYPE_LENGTH_TOO_SHORT
//
// MessageText:
//
//  Data type does not match, length of service parameter too low.
//
#define TLR_E_ECMV4_COE_ABORTCODE_DATATYPE_LENGTH_TOO_SHORT ((TLR_RESULT)0xC0CF8012L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_SUBINDEX_DOES_NOT_EXIST
//
// MessageText:
//
//  Subindex does not exist.
//
#define TLR_E_ECMV4_COE_ABORTCODE_SUBINDEX_DOES_NOT_EXIST ((TLR_RESULT)0xC0CF8013L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_RANGE_OF_PARAMETER_EXCEEDED
//
// MessageText:
//
//  Value range of parameter exceeded (only for write access).
//
#define TLR_E_ECMV4_COE_ABORTCODE_RANGE_OF_PARAMETER_EXCEEDED ((TLR_RESULT)0xC0CF8014L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_VALUE_OF_PARAM_WRITTEN_TOO_HIGH
//
// MessageText:
//
//  Value of parameter written too high.
//
#define TLR_E_ECMV4_COE_ABORTCODE_VALUE_OF_PARAM_WRITTEN_TOO_HIGH ((TLR_RESULT)0xC0CF8015L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_VALUE_OF_PARAM_WRITTEN_TOO_LOW
//
// MessageText:
//
//  Value of parameter written too low.
//
#define TLR_E_ECMV4_COE_ABORTCODE_VALUE_OF_PARAM_WRITTEN_TOO_LOW ((TLR_RESULT)0xC0CF8016L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_MIN_VALUE_IS_LESS_THAN_MAX_VALUE
//
// MessageText:
//
//  Maximum value is less than minimum value.
//
#define TLR_E_ECMV4_COE_ABORTCODE_MIN_VALUE_IS_LESS_THAN_MAX_VALUE ((TLR_RESULT)0xC0CF8017L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_GENERAL_ERROR
//
// MessageText:
//
//  General error.
//
#define TLR_E_ECMV4_COE_ABORTCODE_GENERAL_ERROR ((TLR_RESULT)0xC0CF8018L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_NO_TRANSFER_TO_APP
//
// MessageText:
//
//  Data cannot be transferred or stored to the application.
//
#define TLR_E_ECMV4_COE_ABORTCODE_NO_TRANSFER_TO_APP ((TLR_RESULT)0xC0CF8019L)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_LOCAL_CONTROL
//
// MessageText:
//
//  Data cannot be transferred or stored to the application because of local control.
//
#define TLR_E_ECMV4_COE_ABORTCODE_LOCAL_CONTROL ((TLR_RESULT)0xC0CF801AL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_NO_TRANSFER_DUE_TO_CURRENT_STATE
//
// MessageText:
//
//  Data cannot be transferred or stored to the application because of the present device state.
//
#define TLR_E_ECMV4_COE_ABORTCODE_NO_TRANSFER_DUE_TO_CURRENT_STATE ((TLR_RESULT)0xC0CF801BL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_NO_OBJECT_DICTIONARY_PRESENT
//
// MessageText:
//
//  Object dictionary dynamic generation fails or no object dictionary is present.
//
#define TLR_E_ECMV4_COE_ABORTCODE_NO_OBJECT_DICTIONARY_PRESENT ((TLR_RESULT)0xC0CF801CL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_UNKNOWN_ABORT_CODE
//
// MessageText:
//
//  Unknown SDO abort code.
//
#define TLR_E_ECMV4_COE_ABORTCODE_UNKNOWN_ABORT_CODE ((TLR_RESULT)0xC0CF801DL)

//
// MessageId: TLR_E_ECMV4_COE_ABORTCODE_GEN_INTERNAL_INCOMPAT
//
// MessageText:
//
//  General internal incompatibility in the device.
//
#define TLR_E_ECMV4_COE_ABORTCODE_GEN_INTERNAL_INCOMPAT ((TLR_RESULT)0xC0CF801EL)

/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 EoE Error codes
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 SoE Error codes
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 ENI Error codes
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 ALSTATUSCODE Error codes
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// ECMv4 IF Error codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ECMV4_IF_COE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  CoE Support not available.
//
#define TLR_E_ECMV4_IF_COE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0D60001L)

//
// MessageId: TLR_E_ECMV4_IF_SOE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  SoE Support not available.
//
#define TLR_E_ECMV4_IF_SOE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0D60002L)

//
// MessageId: TLR_E_ECMV4_IF_FOE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  FoE Support not available.
//
#define TLR_E_ECMV4_IF_FOE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0D60003L)

//
// MessageId: TLR_E_ECMV4_IF_AOE_SUPPORT_NOT_AVAILABLE
//
// MessageText:
//
//  AoE Support not available.
//
#define TLR_E_ECMV4_IF_AOE_SUPPORT_NOT_AVAILABLE ((TLR_RESULT)0xC0D60004L)

//
// MessageId: TLR_E_ECMV4_IF_INVALID_TRANSPORT_TYPE
//
// MessageText:
//
//  Invalid transport type.
//
#define TLR_E_ECMV4_IF_INVALID_TRANSPORT_TYPE ((TLR_RESULT)0xC0D60005L)

//
// MessageId: TLR_E_ECMV4_IF_SOE_INVALID_DRIVE_NO
//
// MessageText:
//
//  SoE: Invalid drive number.
//
#define TLR_E_ECMV4_IF_SOE_INVALID_DRIVE_NO ((TLR_RESULT)0xC0D60006L)

//
// MessageId: TLR_E_ECMV4_IF_SOE_INVALID_ELEMENT_FLAGS
//
// MessageText:
//
//  Invalid element flags.
//
#define TLR_E_ECMV4_IF_SOE_INVALID_ELEMENT_FLAGS ((TLR_RESULT)0xC0D60007L)

//
// MessageId: TLR_E_ECMV4_IF_INVALID_SOE_TRANSFER_ID
//
// MessageText:
//
//  Invalid SoE Transfer Id.
//
#define TLR_E_ECMV4_IF_INVALID_SOE_TRANSFER_ID ((TLR_RESULT)0xC0D60008L)

//
// MessageId: TLR_E_ECMV4_IF_TRANSFER_ABORTED
//
// MessageText:
//
//  Transfer aborted.
//
#define TLR_E_ECMV4_IF_TRANSFER_ABORTED  ((TLR_RESULT)0xC0D60009L)

//
// MessageId: TLR_E_ECMV4_IF_OUT_OF_PACKETS
//
// MessageText:
//
//  Out of packets.
//
#define TLR_E_ECMV4_IF_OUT_OF_PACKETS    ((TLR_RESULT)0xC0D6000AL)

//
// MessageId: TLR_E_ECMV4_IF_OUT_OF_TRANSFER_CONTEXTS
//
// MessageText:
//
//  Out of transfer contexts.
//
#define TLR_E_ECMV4_IF_OUT_OF_TRANSFER_CONTEXTS ((TLR_RESULT)0xC0D6000BL)

//
// MessageId: TLR_E_ECMV4_IF_INVALID_SUBINDEX_FOR_COMPLETE_ACCESS
//
// MessageText:
//
//  Invalid subindex for Complete Access.
//
#define TLR_E_ECMV4_IF_INVALID_SUBINDEX_FOR_COMPLETE_ACCESS ((TLR_RESULT)0xC0D6000CL)

//
// MessageId: TLR_E_ECMV4_IF_INVALID_COE_TRANSFER_ID
//
// MessageText:
//
//  Invalid CoE Transfer Id.
//
#define TLR_E_ECMV4_IF_INVALID_COE_TRANSFER_ID ((TLR_RESULT)0xC0D6000DL)

//
// MessageId: TLR_E_ECMV4_IF_INVALID_COE_SDOINFO_LISTTYPE
//
// MessageText:
//
//  Invalid CoE SDOINFO ListType.
//
#define TLR_E_ECMV4_IF_INVALID_COE_SDOINFO_LISTTYPE ((TLR_RESULT)0xC0D6000EL)

//
// MessageId: TLR_E_ECMV4_IF_FILE_READ_ERROR
//
// MessageText:
//
//  File Read Error.
//
#define TLR_E_ECMV4_IF_FILE_READ_ERROR   ((TLR_RESULT)0xC0D6000FL)

//
// MessageId: TLR_E_ECMV4_IF_COULD_NOT_OPEN_FILE
//
// MessageText:
//
//  Could not open file.
//
#define TLR_E_ECMV4_IF_COULD_NOT_OPEN_FILE ((TLR_RESULT)0xC0D60010L)

//
// MessageId: TLR_E_ECMV4_IF_INVALID_CONFIG_NXD
//
// MessageText:
//
//  Invalid config.nxd.
//
#define TLR_E_ECMV4_IF_INVALID_CONFIG_NXD ((TLR_RESULT)0xC0D60011L)

//
// MessageId: TLR_E_ECMV4_IF_CONFIG_NXD_WITHOUT_SLAVES
//
// MessageText:
//
//  Config.nxd without slaves.
//
#define TLR_E_ECMV4_IF_CONFIG_NXD_WITHOUT_SLAVES ((TLR_RESULT)0xC0D60012L)




#endif  //__ECMV4_ERROR_H

